﻿using System;
using System.Diagnostics;
using System.Net;
using System.Net.Sockets;
using System.Text;

string IPADDRESS = "10.10.10.10";                                   // IP address , change it to your own
int PORT = 55002;                                                      // UDP port for broadcasting
try { 
    if (args.Length >= 1)
    {
        IPADDRESS = args[0];                                        // if a start paramter is given , use that as IP
        if (args.Length >= 2)
        {
            PORT = int.Parse(args[1]);                              // if a start paramter is given , use that as port
        }
    }
    byte[] bytes = new byte[1024];
    Console.WriteLine("Get process temperature (IP " + IPADDRESS + ")...");
    IPAddress ipAddress = IPAddress.Parse(IPADDRESS);
    IPEndPoint remoteEP = new IPEndPoint(ipAddress, PORT);
    Socket client = new Socket(ipAddress.AddressFamily, SocketType.Stream, ProtocolType.Tcp);
    client.Connect(remoteEP);
    client.ReceiveTimeout = 250;                                                            // 10ms receive timeout 
    if (client.Connected)
    {
        List<byte> cmd = new List<byte>(Encoding.UTF8.GetBytes("IR-MODUL2-CMD"));           // command header
        cmd.AddRange(Encoding.UTF8.GetBytes("?T"));                                        // add 
        cmd.AddRange(new byte[] { 0x00, 0x00, 0x00, 0x32 });                                // add CT command ( 0x0000 -> not used , 0x0032 -> timeout ms )                   
        Console.WriteLine(" - Connection established and send command !\n");
        Console.WriteLine(" Press any key to abort !\n");
        do   // repeat until key pressed
        {
            client.Send(cmd.ToArray());                                                     // send 
            int bytecount = client.Receive(bytes);                                          // try to receive repsonse
            if (bytecount > 0)                                                              // if bytes received
            {
                string recstr = System.Text.Encoding.UTF8.GetString(bytes,0, bytecount);
                recstr = recstr.Replace("\r", " "); recstr = recstr.Replace("\n", " ");     // replace CR/LF with " "
                Console.WriteLine("Answer : " + recstr + "                    ");
            }
            else Console.WriteLine("ERROR : receive timeout !");
            Console.CursorTop--;
        } while (!Console.KeyAvailable);
        client.Close();                                                                     // close client
    }
}
catch (Exception e)
{
    Console.WriteLine("Unexpected exception : {0}", e.ToString());
}

