﻿using System.Diagnostics;
using System.Net;
using System.Net.Sockets;
using System.Text;

string IPADDRESS = "10.10.10.10";                                   // IP address , change it to your own
int PORT = 55001;                                                   // UDP port for broadcasting
try
{
    if (args.Length >= 1)
    {
        IPADDRESS = args[0];                                        // if a start paramter is given , use that as IP
        if (args.Length >= 2)
        {
            PORT = int.Parse(args[1]);                              // if a start paramter is given , use that as port
        }
    }
    byte[] rb = new byte[1024];
    Console.WriteLine("Get configuration (IP " + IPADDRESS + ")...");
    IPAddress ipAddress = IPAddress.Parse(IPADDRESS);
    IPEndPoint remoteEP = new IPEndPoint(ipAddress, PORT);
    Socket client = new Socket(ipAddress.AddressFamily, SocketType.Stream, ProtocolType.Tcp);
    client.Connect(remoteEP);
    client.ReceiveTimeout = 100;                                    // 10ms receive timeout 
    if (client.Connected)
    {
        Console.WriteLine(" - Connection established !\n");
        Console.WriteLine("current configuration :\n");

        List<byte> cmd = new List<byte>(Encoding.UTF8.GetBytes("IR-MODUL2-CONF"));       // get/set configuration header
        cmd.AddRange(new byte[] { 0x00, 0x01, 0xff, 0xff, 0xff, 0xff });                // add conf. command (0x0000 -> value index , 0xffffffff -> get value (otherwise set)                   
        int bytecount;
        client.Send(cmd.ToArray());                                 // send 
        bytecount = client.Receive(rb);                             // try to receive repsonse
        bool timeout = true;
        if (bytecount == 4)                                         // 4 bytes received ?
        {
            string macaddress = string.Format("{0:X02}:{1:X02}:{2:X02}:", rb[1], rb[2], rb[3]);
            cmd[cmd.Count - 5] = 0x00;
            client.Send(cmd.ToArray());                                 // send 
            bytecount = client.Receive(rb);                             // try to receive repsonse
            if (bytecount == 4)                                         // 4 bytes received ?
            {
                macaddress += string.Format("{0:X02}:{1:X02}:{2:X02}:", rb[1], rb[2], rb[3]);
                Console.WriteLine("\t\tMAC address :\t" + macaddress);
                cmd[cmd.Count - 5] = 0x02;
                client.Send(cmd.ToArray());                                 // send 
                bytecount = client.Receive(rb);                             // try to receive repsonse
                if (bytecount == 4)                                         // 4 bytes received ?
                {
                    string ipmode = rb[3] == 1 ? "DHCP" : "STATIC";
                    Console.WriteLine("\t\tIP mode :\t" + ipmode);
                    cmd[cmd.Count - 5] = 0x03;
                    client.Send(cmd.ToArray());                                 // send 
                    bytecount = client.Receive(rb);                             // try to receive repsonse
                    if (bytecount == 4)                                         // 4 bytes received ?
                    {
                        string staticip = string.Format("{0}.{1}.{2}.{3}", rb[0], rb[1], rb[2], rb[3]);
                        Console.WriteLine("\t\tstatic IP :\t" + staticip);
                        cmd[cmd.Count - 5] = 0x04;
                        client.Send(cmd.ToArray());                                 // send 
                        bytecount = client.Receive(rb);                             // try to receive repsonse
                        if (bytecount == 4)                                         // 4 bytes received ?
                        {
                            string netmask = string.Format("{0}.{1}.{2}.{3}", rb[0], rb[1], rb[2], rb[3]);
                            Console.WriteLine("\t\tNetmask :\t" + netmask);
                            cmd[cmd.Count - 5] = 0x07;
                            client.Send(cmd.ToArray());                                 // send 
                            bytecount = client.Receive(rb);                             // try to receive repsonse
                            if (bytecount == 4)                                         // 4 bytes received ?
                            {
                                int port_cfg = rb[2] * 256 + rb[3];
                                Console.WriteLine("\t\t" + port_cfg.ToString("PORT CFG :\t0"));
                                cmd[cmd.Count - 5] = 0x05;
                                client.Send(cmd.ToArray());                                 // send 
                                bytecount = client.Receive(rb);                             // try to receive repsonse
                                if (bytecount == 4)                                         // 4 bytes received ?
                                {
                                    int port_cmd = rb[2] * 256 + rb[3];
                                    Console.WriteLine("\t\t" + port_cmd.ToString("PORT CMD :\t0"));
                                    cmd[cmd.Count - 5] = 0x06;
                                    client.Send(cmd.ToArray());                                 // send 
                                    bytecount = client.Receive(rb);                             // try to receive repsonse
                                    if (bytecount == 4)                                         // 4 bytes received ?
                                    {
                                        int port_modbus = rb[2] * 256 + rb[3];
                                        Console.WriteLine("\t\t" + port_modbus.ToString("PORT MODBUS :\t0"));
                                        timeout = false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (timeout) Console.WriteLine("ERROR : receive timeout !");
        client.Close();                                             // close client
    }
}
catch (Exception e)
{
    Console.WriteLine("Unexpected exception : {0}", e.ToString());
}

